<?php
return [
    'name' => env('APP_NAME', '麒麟教育'),
    'logo' => '@admin/images/logo.png',
    'logo-mini' => '@admin/images/logo.png',
    'favicon' => '@admin/images/logo.png',
    'default_avatar' => '@admin/images/logo.png',
    'route' => [
        'domain' => env('ADMIN_ROUTE_DOMAIN'),
        'prefix' => env('ADMIN_ROUTE_PREFIX', 'admin'),
        'namespace' => 'App\\Admin\\Controllers',
        'middleware' => ['web', 'admin'],
        'enable_session_middleware' => false,
    ],
    'directory' => app_path('Admin'),
    'title' => env('APP_NAME', '麒麟教育') . ' - 管理后台',
    'assets_server' => env('ADMIN_ASSETS_SERVER', 'https://static.2025.wangk.cn'),

    /**
     * @deprecated 不再建议使用此配置，如果你使用了反向代理，配置好了 `app/Http/Middleware/TrustProxies.php` 中的 $proxies 属性
     *             你的页面就会自动配置 https 协议。
     *              未来将完全移除此配置
     */
    'https' => env('ADMIN_HTTPS', false),
    'auth' => [
        'enable' => true,
        'controller' => App\Admin\Controllers\AuthController::class,
        'guard' => 'admin',
        'guards' => [
            'admin' => [
                'driver' => 'session',
                'provider' => 'admin',
            ],
        ],

        'providers' => [
            'admin' => [
                'driver' => 'eloquent',
                'model' => Kylin\Admin\Models\Administrator::class,
            ],
        ],
        'remember' => true,
        'except' => [
            'auth/login',
            'auth/logout',
        ],

        'enable_session_middleware' => false,
    ],
    'grid' => [
        'grid_action_class' => Kylin\Admin\Grid\Displayers\DropdownActions::class,
        'batch_action_class' => Kylin\Admin\Grid\Tools\BatchActions::class,
        'paginator_class' => Kylin\Admin\Grid\Tools\Paginator::class,
        'actions' => [
            'view' => Kylin\Admin\Grid\Actions\Show::class,
            'edit' => Kylin\Admin\Grid\Actions\Edit::class,
            'quick_edit' => Kylin\Admin\Grid\Actions\QuickEdit::class,
            'delete' => Kylin\Admin\Grid\Actions\Delete::class,
            'batch_delete' => Kylin\Admin\Grid\Tools\BatchDelete::class,
        ],
        'column_selector' => [
            'store' => Kylin\Admin\Grid\ColumnSelector\SessionStore::class,
            'store_params' => [
                'driver' => 'file',
            ],
        ],
    ],
    'helpers' => [
        'enable' => (bool)env('APP_DEBUG', false),
    ],
    'permission' => [
        'enable' => true,
        'except' => [
            '/',
            'auth/login',
            'auth/logout',
            'auth/setting',
        ],
    ],
    'menu' => [
        'cache' => [
            'enable' => false,
            'store' => 'file',
        ],
        'bind_permission' => true,
        'role_bind_menu' => true,
        'permission_bind_menu' => true,
        'default_icon' => 'feather icon-circle',
    ],
    'upload' => [
        'disk' => 'public',
        'directory' => [
            'image' => 'images',
            'file' => 'files',
        ],
    ],
    'database' => [
        'connection' => '',
        'users_table' => 'admin_users',
        'users_model' => Kylin\Admin\Models\Administrator::class,
        'roles_table' => 'admin_roles',
        'roles_model' => Kylin\Admin\Models\Role::class,
        'permissions_table' => 'admin_permissions',
        'permissions_model' => Kylin\Admin\Models\Permission::class,
        'menu_table' => 'admin_menu',
        'menu_model' => Kylin\Admin\Models\Menu::class,
        'role_users_table' => 'admin_role_users',
        'role_permissions_table' => 'admin_role_permissions',
        'role_menu_table' => 'admin_role_menu',
        'permission_menu_table' => 'admin_permission_menu',
        'settings_table' => 'admin_settings',
        'extensions_table' => 'admin_extensions',
        'extension_histories_table' => 'admin_extension_histories',
    ],
    'layout' => [
        'color' => 'default',
        'body_class' => [],
        'horizontal_menu' => false,
        'sidebar_collapsed' => false,
        'sidebar_style' => 'light',
        'dark_mode_switch' => false,
        'navbar_color' => '',
    ],
    'exception_handler' => Kylin\Admin\Exception\Handler::class,
    'enable_default_breadcrumb' => true,
    'extension' => [
        'dir' => base_path('packages'),
    ],
    'multi_app' => [
        //'shop' => true
    ]
];
