<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\JsonResponse;

abstract class Controller extends \App\Http\Controllers\Controller
{
    /**
     * 返回成功信息
     * @param string $message
     * @param array $data
     * @param int $code
     * @return JsonResponse
     */
    protected function success(string $message = '', array $data = [], int $code = 0): JsonResponse
    {
        $response = [
            'status' => 'success',
            'code' => $code,
            'message' => __($message),
            'data' => $data
        ];
        return response()->json($response);
    }

    /**
     * 返回失败信息
     * @param string $message
     * @param array $data
     * @param int $code
     * @return JsonResponse
     */
    protected function error(string $message = '', array $data = [], int $code = 1): JsonResponse
    {
        $response = [
            'status' => 'error',
            'code' => $code,
            'message' => __($message),
            'data' => $data
        ];
        return response()->json($response);
    }
}
