# 支付模块

## 安装

1. 安装依赖

```bash
composer require kylin/payment
```

2. 发布配置文件

```bash
php artisan vendor:publish --provider="Kylin\Payment\PayServiceProvider"
```

## 使用方法

### 支付宝

```php
use Kylin\Payment\Facades\Pay;

// 支付
$order = Pay::alipay()->web([
    'out_trade_no' => time(),
    'total_amount' => '1',
    'subject' => 'test subject - 测试',
]);
```

### 微信

```php
use Kylin\Payment\Facades\Pay;

// 支付
$order = Pay::wechat()->mp([
    'out_trade_no' => time(),
    'body' => 'subject-测试',
    'total_fee'      => '1',
    'openid' => 'onkVf1FjWS5SBIixxxxxxxxx',
]);
```

### 抖音支付

```php
use Kylin\Payment\Facades\Pay;

// 支付
$order = Pay::douyin()->mini([
    'out_order_no' => date('YmdHis').mt_rand(1000, 9999),
    'total_amount' => 1,
    'subject' => '闫嵩达 - test - subject - 01',
    'body' => '闫嵩达 - test - body - 01',
    'valid_time' => 600,
    'expand_order_info' => json_encode([
        'original_delivery_fee' => 15,
        'actual_delivery_fee' => 10
    ])
]);
```

### 江苏银行支付

```php
use Kylin\Payment\Facades\Pay;

// 支付
$order = Pay::jsb()->scan([
    'outTradeNo' => time().'',
    'proInfo' => 'subject-测试',
    'totalFee'=> 1,
]);
```
