<?php

namespace Kylin\Qiniu;

use Composer\InstalledVersions;
use Illuminate\Filesystem\FilesystemAdapter;
use Illuminate\Foundation\Console\AboutCommand;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\ServiceProvider;
use League\Flysystem\Filesystem;

class QiniuFilesystemServiceProvider extends ServiceProvider
{

    public function boot()
    {
        AboutCommand::add('Kylin', [
            'Qiniu Version' => fn() => InstalledVersions::getPrettyVersion('kylin/qiniu'),
        ]);
        Storage::extend(
            'qiniu',
            function ($app, $config) {
                if (isset($config['domains'])) {
                    $domains = $config['domains'];
                } else {
                    $domains = [
                        'default' => $config['domain'],
                        'https' => null,
                        'custom' => null
                    ];
                }
                $qiniu_adapter = new QiniuAdapter(
                    $config['access_key'],
                    $config['secret_key'],
                    $config['bucket'],
                    $domains,
                    isset($config['notify_url']) ? $config['notify_url'] : null,
                    isset($config['access']) ? $config['access'] : 'public',
                    isset($config['hotlink_prevention_key']) ? $config['hotlink_prevention_key'] : null
                );
                $file_system = new Filesystem($qiniu_adapter);

                return new FilesystemAdapter($file_system, $qiniu_adapter, $config);
            }
        );
    }

    public function register()
    {
        //
    }
}
