<?php

use Overtrue\EasySms\Strategies\OrderStrategy;

return [
    // HTTP 请求的超时时间（秒）
    'timeout' => 5.0,

    // 默认发送配置
    'default' => [
        // 网关调用策略，默认：顺序调用
        'strategy' => OrderStrategy::class,

        // 默认可用的发送网关
        'gateways' => [
            'yunpian', 'aliyun',
        ],
    ],
    // 可用的网关配置
    'gateways' => [
        'errorlog' => [
            'file' => '/tmp/sms.log',
        ],
        'yunpian' => [
            'api_key' => env('EASY_SMS_YUNPIAN_API_KEY'),
        ],
        'aliyun' => [
            'access_key_id' => env('EASY_SMS_ALIYUN_KEY_ID'),
            'access_key_secret' => env('EASY_SMS_ALIYUN_API_KEY'),
            'sign_name' => '',
        ],
        //...
    ],
];
