<?php

namespace Kylin\Sms;

use Composer\InstalledVersions;
use Illuminate\Contracts\Support\DeferrableProvider;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Console\AboutCommand;
use Illuminate\Support\ServiceProvider;
use Overtrue\EasySms\EasySms;

class SmsServiceProvider extends ServiceProvider implements DeferrableProvider
{
    public function boot(): void
    {
        AboutCommand::add('Kylin', [
            'Sms Version' => fn() => InstalledVersions::getPrettyVersion('kylin/sms'),
        ]);

        if ($this->app instanceof Application && $this->app->runningInConsole()) {
            $this->publishes([dirname(__DIR__) . '/config/sms.php' => config_path('sms.php'),], 'kylin-sms');
        }
    }

    public function register(): void
    {
        $this->app->singleton(EasySms::class, function () {
            return new EasySms(config('sms'));
        });

        $this->app->alias(EasySms::class, 'sms');
    }

    public function provides(): array
    {
        return [EasySms::class, 'sms',];
    }
}
